// var base_url = "https://techiebrothers.in:8090";
var base_url = global_base_url;
document.addEventListener('DOMContentLoaded', async () => {
  const myUrl2 = new URL(window.location.toLocaleString());
  console.log("myUrl2",myUrl2)
  // Load the publishable key from the server. The publishable key
  // is set in your .env file.
  const { publishableKey } = await fetch(`${base_url}/api/v1/userPlan/config`).then((r) => r.json());
  if (!publishableKey) {
    addMessage(
      'No publishable key returned from the server. Please check `.env` and try again'
    );
    alert('Please set your Stripe publishable API key in the .env file');
  }

  const stripe = Stripe(publishableKey, {
    apiVersion: '2020-08-27',
  });

  const url = new URL(window.location);
  console.log("url params",url)
  const clientSecret = url.searchParams.get('payment_intent_client_secret');

  await stripe.retrievePaymentIntent(
    clientSecret
  ).then(function (result) {
    if (result.error) {
      addMessage(error.message);
    }
    if (result.paymentIntent.status == "succeeded") {
      addMessage(`Payment ${result.paymentIntent.status}: ${result.paymentIntent.id}`);
      console.log("result", result)
      //Call Update Api for User Plan
      var userPlanDraftString = localStorage.getItem("userD");
      var userPlanDraft = JSON.parse(userPlanDraftString);
      const data = {
        "id":userPlanDraft.data.id,
        "user": userPlanDraft.data.user,
        "amount": 200,
        "plan": userPlanDraft.data.plan,
        "stripePaymentId": result.paymentIntent.id
      }

      fetch(`${base_url}/api/v1/userPlan/update`,
        {
          method: "post",
          headers: {
            'Accept': 'application/json, text/plain, */*',
            'Content-Type': 'application/json'
          },
          body: JSON.stringify(data)
        }
      ).then((res) => res.json())
      .then((response) => {
        addMessage("Plan purchased : Plan Purchase Id : [ " + response.data.id +" ]");
      })
    }
  });

  // console.log("Payament intent Id",paymentIntent.id)
  
});